<?php
// Ubicación: public_html/asesoria.virtualex.ec/app/Views/chat.php
session_start();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Asesoría Virtualex | IA</title>
    <!-- Tailwind CSS (CDN) -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Marked.js para renderizar Markdown -->
    <script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
    <!-- Estilos Propios -->
    <link rel="stylesheet" href="/css/style.css">
</head>
<body class="bg-gray-50 h-screen flex flex-col font-sans">

    <!-- Header -->
    <nav class="bg-blue-900 text-white shadow-lg z-10">
        <div class="container mx-auto px-4 py-3 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <span class="text-2xl">⚖️</span>
                <div>
                    <h1 class="font-bold tracking-wide leading-tight">VIRTUALEX</h1>
                    <span class="text-xs text-blue-200 uppercase tracking-widest">Asesoría IA</span>
                </div>
            </div>
            <div class="flex items-center gap-4 text-sm">
                <div class="bg-blue-800/50 px-3 py-1 rounded-full border border-blue-700 backdrop-blur-sm">
                    Créditos: <span id="balanceDisplay" class="font-bold text-yellow-400">...</span>
                </div>
                <a href="/logout" class="hover:text-white text-blue-200 transition-colors">Salir</a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="flex-grow container mx-auto p-4 max-w-6xl flex gap-6 h-[calc(100vh-64px)]">
        
        <!-- Left Column: Chat -->
        <div class="flex-grow bg-white rounded-xl shadow-sm border border-gray-200 flex flex-col overflow-hidden">
            
            <!-- Chat History Area -->
            <div id="chatHistory" class="flex-grow p-6 overflow-y-auto space-y-4 bg-slate-50">
                <!-- Welcome Message -->
                <div class="bg-white border border-gray-200 p-5 rounded-xl shadow-sm max-w-[90%]">
                    <h3 class="font-bold text-blue-900 mb-2">👋 Bienvenido al Asistente Legal Virtualex</h3>
                    <p class="text-gray-600 text-sm leading-relaxed">
                        Estoy conectado a la base de datos de legislación ecuatoriana. 
                        Puedes preguntarme sobre leyes, reglamentos, resoluciones del SRI o consultas laborales.
                    </p>
                </div>
            </div>

            <!-- Input Area -->
            <div class="p-4 bg-white border-t border-gray-100">
                <form id="chatForm" class="relative group">
                    <textarea id="userQuery" rows="3" 
                        class="w-full p-4 pr-16 rounded-xl bg-gray-50 border-gray-200 border focus:bg-white focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none resize-none text-gray-700 transition-all placeholder-gray-400" 
                        placeholder="Ej: ¿Cuáles son las obligaciones del empleador en caso de despido intempestivo?"></textarea>
                    
                    <button type="submit" id="sendBtn" 
                        class="absolute right-3 bottom-3 bg-blue-600 hover:bg-blue-700 text-white p-2.5 rounded-lg transition-colors shadow-sm disabled:opacity-50 disabled:cursor-not-allowed">
                        <svg class="w-5 h-5 transform rotate-90" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path></svg>
                    </button>
                </form>
                <div class="text-xs text-center text-gray-400 mt-2">
                    La IA puede cometer errores. Verifica la información con los documentos originales.
                </div>
            </div>
        </div>

        <!-- Right Column: Citations (Desktop) -->
        <div class="w-80 hidden lg:flex flex-col gap-4">
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 flex flex-col h-full overflow-hidden">
                <div class="bg-gray-50 px-4 py-3 border-b border-gray-200 flex justify-between items-center">
                    <h3 class="font-bold text-gray-700 text-xs uppercase tracking-wider">Fuentes Consultadas</h3>
                    <span class="text-xs text-gray-400" id="docsCount">0 docs</span>
                </div>
                <div id="citationsList" class="flex-grow overflow-y-auto p-3 space-y-3 custom-scrollbar">
                    <!-- Estado vacío -->
                    <div class="flex flex-col items-center justify-center h-40 text-gray-400 text-sm text-center px-4">
                        <svg class="w-10 h-10 mb-2 opacity-30" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path></svg>
                        <span>Haz una pregunta para ver las fuentes legales aquí.</span>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- App Logic -->
    <script src="/js/app.js"></script>
</body>
</html>