<?php
// Ubicación: public_html/asesoria.virtualex.ec/app/Services/GeminiService.php

namespace App\Services;

use Exception;

class GeminiService {
    private string $apiKey;
    private string $endpoint;
    private string $model = 'gemini-1.5-flash';

    public function __construct() {
        // REEMPLAZAR CON TU API KEY REAL
        $this->apiKey = 'TU_API_KEY_AQUI'; 
        $this->endpoint = "https://generativelanguage.googleapis.com/v1beta/models/" . $this->model . ":generateContent?key=" . $this->apiKey;
    }

    public function generateResponse(string $userQuery, array $documents): array {
        // 1. Construir Contexto
        $contextText = "";
        foreach ($documents as $doc) {
            $contextText .= "--- DOCUMENTO ID: {$doc['id']} ---\n";
            $contextText .= "TÍTULO: {$doc['titulo']}\n";
            $contextText .= "FECHA: {$doc['fecha']}\n";
            $contextText .= "EMISOR: {$doc['emisor']}\n";
            $contextText .= "RESUMEN: {$doc['resumen']}\n";
            $contextText .= "CONTENIDO RELEVANTE: {$doc['contenido']}\n\n";
        }

        // 2. Prompt del Sistema
        $systemInstruction = "Eres un abogado experto en legislación ecuatoriana y tributación. " .
            "Tu tarea es responder a la pregunta del usuario basándote ÚNICAMENTE en el contexto legal proporcionado abajo. " .
            "Debes citar explícitamente el título del documento y su fecha cuando uses información de él. " .
            "Si la respuesta no se encuentra en el contexto, indica claramente que no hay fundamento suficiente en los documentos encontrados.";

        // 3. Payload JSON
        $payload = [
            "contents" => [
                [
                    "role" => "user",
                    "parts" => [
                        ["text" => "CONTEXTO LEGAL:\n" . $contextText . "\n\nPREGUNTA USUARIO:\n" . $userQuery]
                    ]
                ]
            ],
            "systemInstruction" => [
                "parts" => [
                    ["text" => $systemInstruction]
                ]
            ],
            "generationConfig" => [
                "temperature" => 0.3, // Baja temperatura para respuestas más factuales
                "maxOutputTokens" => 2000
            ]
        ];

        // 4. Llamada cURL
        $ch = curl_init($this->endpoint);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        $start = microtime(true);
        $response = curl_exec($ch);
        $latency = (int)((microtime(true) - $start) * 1000);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode !== 200) {
            throw new Exception("Error Gemini API ($httpCode): " . $response);
        }

        $json = json_decode($response, true);
        
        $text = $json['candidates'][0]['content']['parts'][0]['text'] ?? "Lo siento, hubo un error generando la respuesta.";
        $usage = $json['usageMetadata'] ?? ['promptTokenCount' => 0, 'candidatesTokenCount' => 0];

        return [
            'text' => $text,
            'input_tokens' => $usage['promptTokenCount'],
            'output_tokens' => $usage['candidatesTokenCount'],
            'latency' => $latency,
            'status' => $httpCode
        ];
    }
}