<?php
// Ubicación: public_html/asesoria.virtualex.ec/app/Config/Database.php

namespace App\Config;

use PDO;
use PDOException;

class Database {
    // ==========================================
    // 1. BASE DE DATOS NUEVA (Gestión de App)
    // ==========================================
    private const DB_HOST = 'localhost';
    private const DB_NAME = 'virtualex_asesoria';
    private const DB_USER = 'virtualex_general';
    private const DB_PASS = 'XkGWN;DyoD%$';

    // ==========================================
    // 2. BASE DE DATOS LEGADO (Documentos MyISAM)
    // ==========================================
    private const LEGACY_HOST = 'localhost';
    private const LEGACY_NAME = 'virtualex_app_sistema';
    // Usamos el mismo usuario asumiendo que tiene permisos en ambas
    private const LEGACY_USER = 'virtualex_general';
    private const LEGACY_PASS = 'XkGWN;DyoD%$';

    private static ?PDO $connApp = null;
    private static ?PDO $connLegacy = null;

    /**
     * Conexión a la base nueva (UTF-8)
     */
    public static function getApp(): PDO {
        if (self::$connApp === null) {
            try {
                $dsn = "mysql:host=" . self::DB_HOST . ";dbname=" . self::DB_NAME . ";charset=utf8mb4";
                self::$connApp = new PDO($dsn, self::DB_USER, self::DB_PASS, [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                ]);
            } catch (PDOException $e) {
                // En producción, no mostrar $e->getMessage() al usuario final
                error_log("Error conexión App DB: " . $e->getMessage());
                die("Error de conexión al sistema.");
            }
        }
        return self::$connApp;
    }

    /**
     * Conexión a la base antigua (Latin1)
     */
    public static function getLegacy(): PDO {
        if (self::$connLegacy === null) {
            try {
                $dsn = "mysql:host=" . self::LEGACY_HOST . ";dbname=" . self::LEGACY_NAME;
                // NOTA: No definimos charset en DSN para manejar manualmente la conversión de Latin1
                self::$connLegacy = new PDO($dsn, self::LEGACY_USER, self::LEGACY_PASS, [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES latin1"
                ]);
            } catch (PDOException $e) {
                error_log("Error conexión Legacy DB: " . $e->getMessage());
                die("Error de conexión a la base legal.");
            }
        }
        return self::$connLegacy;
    }
}